<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Cms
 */

namespace Totem\Cms\Setup;

use Magento\Framework\Setup\UpgradeSchemaInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;

/**
 * @codeCoverageIgnore
 */
class UpgradeSchema implements UpgradeSchemaInterface
{
   /**
    * Add date options to schedule cms blocks
    */
   public function upgrade(SchemaSetupInterface $setup, ModuleContextInterface $context)
   {
      $setup->startSetup();
   
      if (version_compare($context->getVersion(), '0.0.3') < 0):
         $setup->getConnection()->addColumn(
            $setup->getTable('cms_block'),
            'visible_from_date',
            [
               'type'      => \Magento\Framework\DB\Ddl\Table::TYPE_DATETIME,
               'length'    => null,
               'nullable'  => true,
               'comment'   => 'Visible From Date',
               'after'     => 'is_active'
            ]
         );
   
         $setup->getConnection()->addColumn(
            $setup->getTable('cms_block'),
            'visible_to_date',
            [
               'type'      => \Magento\Framework\DB\Ddl\Table::TYPE_DATETIME,
               'length'    => null,
               'nullable'  => true,
               'comment'   => 'Visible To Date',
               'after'     => 'visible_from_date'
            ]
         );
      endif;
   
      if (version_compare($context->getVersion(), '1.0.2') < 0):
         $setup->getConnection()->addColumn(
            $setup->getTable('cms_page'),
            'content_image',
            [
               'type'      => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
               'comment'   => 'Page Content Image',
               'after'     => 'content_heading'
            ]
         );
      endif;
   
      $setup->endSetup();
   }
}