<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Cms
 */

namespace Totem\Cms\Setup;

use Magento\Framework\Setup\InstallSchemaInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;

/**
 * @codeCoverageIgnore
 */
class InstallSchema implements InstallSchemaInterface
{
   /**
    * Add option to hide breadcrumbs on cms pages
    */
   public function install(SchemaSetupInterface $setup, ModuleContextInterface $context)
   {
      $installer = $setup;
      $installer->startSetup();
      $setup->getConnection()->addColumn(
         $setup->getTable('cms_page'),
         'show_breadcrumbs',
         [
            'type' => \Magento\Framework\DB\Ddl\Table::TYPE_SMALLINT,
            'nullable' => false,
            'default' => 1,
            'comment' => 'Show Breadcrumbs'
         ]
      );
      $installer->endSetup();
   }
}