<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Cms
 */

namespace Totem\Cms\Plugin\Model\ResourceModel;

use Magento\Cms\Model\ResourceModel\Block as BlockResource;
use Magento\Cms\Model\Block;

class BlockPlugin
{
   /**
    * @var \Magento\Framework\Stdlib\DateTime
    */
   protected $dateTime;

   /**
    * @param \Magento\Framework\Stdlib\DateTime $dateTime
    */
   public function __construct(
      \Magento\Framework\Stdlib\DateTime $dateTime
   ) {
      $this->dateTime = $dateTime;
   }
   
   /**
    * Manipulates the Block entity before it is saved
    *
    * @param BlockResource $blockResource
    * @param Block $block
    */
   public function beforeSave(BlockResource $blockResource, Block $block, ... $arguments) // NOSONAR
   {
      foreach (['visible_from_date', 'visible_to_date'] as $field):
         $value = !$block->getData($field) ? null : $this->dateTime->formatDate($block->getData($field));
         $block->setData($field, $value);
      endforeach;
   }
}
