<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2019 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Cms
 */

namespace Totem\Cms\Plugin\Model\Page;

use Magento\Framework\Filesystem;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Catalog\Model\ImageUploader;

class DataProviderPlugin
{
   /**
    * @var Filesystem
    */
   protected $filesystem;
   
   /**
    * @var StoreManagerInterface
    */
   protected $storeManager;
   
   /**
    * @var ImageUploader
    */
   protected $imageUploader;
   
   /**
    * @param Filesystem $filesystem;
    * @param StoreManagerInterface $storeManager;
    * @param ImageUploader $imageUploader;
    */
   public function __construct(
      Filesystem $filesystem,
      StoreManagerInterface $storeManager,
      ImageUploader $imageUploader
   ) {
      $this->filesystem    = $filesystem;
      $this->storeManager  = $storeManager;
      $this->imageUploader = $imageUploader;
   }
   
   /**
    * @param \Magento\Cms\Model\Page\DataProvider $subject
    * @param $result
    *
    * @return array
    */
   public function afterGetData(\Magento\Cms\Model\Page\DataProvider $subject, $result)
   {
      if(!is_array($result)):
         return $result;
      endif;
      
      foreach($result as $pageId => $data):
         if (isset($data['content_image'])):
            unset($result[$pageId]['content_image']);
         
            $fileName   = $data['content_image'];
            $serverPath = $this->filesystem->getDirectoryRead(\Magento\Framework\App\Filesystem\DirectoryList::MEDIA)
                                           ->getAbsolutePath() . $this->imageUploader->getBasePath() . "/" . $fileName;
            $fullPath   = $this->storeManager->getStore()->getBaseUrl(\Magento\Framework\UrlInterface::URL_TYPE_MEDIA) . $this->imageUploader->getBasePath() . "/" . $fileName;
            
            if (file_exists($serverPath)):
               $stat = stat($serverPath);
               $mime = mime_content_type($serverPath);
         
               $result[$pageId]["content_image"][0]['name']   = $fileName;
               $result[$pageId]["content_image"][0]['url']    = $fullPath;
               $result[$pageId]['content_image'][0]['size']   = isset($stat) ? $stat['size'] : 0;
               $result[$pageId]['content_image'][0]['type']   = $mime;
            endif;
         endif;
      endforeach;
   
      return $result;
   }
}