<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2019 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Cms
 */

namespace Totem\Cms\Plugin\Controller\Adminhtml\Page;

use Magento\Framework\Filesystem;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Catalog\Model\ImageUploader;

class SavePlugin
{
   /**
    * @var Filesystem
    */
   protected $filesystem;
   
   /**
    * @var StoreManagerInterface
    */
   protected $storeManager;
   
   /**
    * @var ImageUploader
    */
   protected $imageUploader;
   
   /**
    * @param Filesystem $filesystem;
    * @param StoreManagerInterface $storeManager;
    * @param ImageUploader $imageUploader;
    */
   public function __construct(
      Filesystem $filesystem,
      StoreManagerInterface $storeManager,
      ImageUploader $imageUploader
   ) {
      $this->filesystem    = $filesystem;
      $this->storeManager  = $storeManager;
      $this->imageUploader = $imageUploader;
   }
   
   /**
    * @param \Magento\Cms\Controller\Adminhtml\Page\Save $subject
    *
    * @return \Magento\Cms\Controller\Adminhtml\Page\Save
    * @throws \Magento\Framework\Exception\LocalizedException
    */
   public function beforeExecute(\Magento\Cms\Controller\Adminhtml\Page\Save $subject)
   {
      $data = $subject->getRequest()->getPostValue();
   
      $contentImage = null;
      if(isset($data['content_image'][0]['name']) && isset($data['content_image'][0]['tmp_name'])):
         $contentImage = $data['content_image'][0]['name'];
      
         $this->imageUploader->moveFileFromTmp($contentImage);
      elseif(isset($data['content_image'][0]['name']) && !isset($data['content_image'][0]['tmp_name'])):
         $contentImage = $data['content_image'][0]['name'];
      endif;
   
      $subject->getRequest()->setPostValue('content_image', $contentImage);
      
      return $subject;
   }
}