<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2018 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Cms
 * @comment    Make it possible to upload different filetypes inside the WYSIWYG-editor. Extra filetypes are PDF (pdf), Word (doc, docx), Excel (xls, xlsx, csv), Powerpoint (ppt, pptx), SVG (svg)
 */

namespace Totem\Cms\Plugin\Block\Adminhtml\Wysiwyg\Images\Content;

use Totem\Cms\Helper\Data as CmsHelper;

class FilesPlugin
{
   /**
    * @var CmsHelper
    */
   protected $cmsHelper;
   
   /**
    * @var \Magento\Framework\View\Asset\Repository
    */
   protected $assetRepository;
   
   /**
    * @param CmsFileTypes $cmsFileTypes
    * @param \Magento\Framework\View\Asset\Repository $assetRepository
    */
   public function __construct(
      CmsHelper $cmsHelper,
      \Magento\Framework\View\Asset\Repository $assetRepository
   ) {
      $this->cmsHelper        = $cmsHelper;
      $this->assetRepository  = $assetRepository;
   }
   
   /**
    * Change file thumbnail image based on the extension
    *
    * @param $subject
    * @param $result
    * @param $file
    *
    * @return string
    */
   public function afterGetFileThumbUrl($subject, $result, $file)
   {
      $pathinfo = pathinfo($file->getName());
   
      if(!$this->cmsHelper->isCustomFileType($pathinfo)):
         return $result;
      endif;
   
      $fileIcon      = 'Totem_Cms::images/' . $pathinfo['extension'] . '.png';
      $fileIconUrl   = $this->assetRepository->getUrl($fileIcon);
      
      return $fileIconUrl;
   }
}