<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2018 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Cms
 * @comment    Make it possible to upload different filetypes inside the WYSIWYG-editor. Extra filetypes are PDF (pdf), Word (doc, docx), Excel (xls, xlsx, csv), Powerpoint (ppt, pptx), SVG (svg)
 */

namespace Totem\Cms\Image\Adapter;

use Totem\Cms\Helper\Data as CmsHelper;

class Gd2 extends \Magento\Framework\Image\Adapter\Gd2
{
   /**
    * @var CmsHelper
    */
   protected $cmsHelper;
   
   /**
    * Gd2 constructor.
    *
    * @param \Magento\Framework\Filesystem $filesystem
    * @param \Psr\Log\LoggerInterface      $logger
    * @param CmsSettings                   $cmsHelper
    * @param array                         $data
    */
   public function __construct(
      \Magento\Framework\Filesystem $filesystem,
      \Psr\Log\LoggerInterface $logger,
      CmsHelper $cmsHelper,
      array $data = []
   ) {
      $this->cmsHelper = $cmsHelper;
      
      parent::__construct($filesystem, $logger, $data);
   }
   
   /**
    * Open image for processing
    *
    * @param string $filename
    * @return void
    * @throws \OverflowException
    */
   public function open($filename)
   {
      $pathinfo = pathinfo($filename);
      if(!$this->cmsHelper->isCustomFileType($pathinfo)):
         parent::open($filename);
      endif;
   }
   
   /**
    * Save image to specific path.
    * If some folders of path does not exist they will be created
    *
    * @param null|string $destination
    * @param null|string $newName
    * @return void
    * @throws \Exception  If destination path is not writable
    */
   public function save($destination = null, $newName = null)
   {
      $fileName = $this->_prepareDestination($destination, $newName);
      $pathinfo = pathinfo($fileName);
      if(!$this->cmsHelper->isCustomFileType($pathinfo)):
         parent::save($destination, $newName);
      endif;
   }
}