<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2019 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Cms
 */

namespace Totem\Cms\Controller\Adminhtml\Page\Image;

use Magento\Framework\Controller\ResultFactory;
use Magento\Catalog\Model\ImageUploader;

/**
 * Class Upload
 */
class Upload extends \Magento\Backend\App\Action
{
   /**
    * @var ImageUploader
    */
   protected $imageUploader;
   
   /**
    * Upload constructor.
    *
    * @param \Magento\Backend\App\Action\Context $context
    * @param \Magento\Catalog\Model\ImageUploader $imageUploader
    */
   public function __construct(
      \Magento\Backend\App\Action\Context $context,
      ImageUploader $imageUploader
   ) {
      parent::__construct($context);
      
      $this->imageUploader = $imageUploader;
   }
   
   /**
    * Upload file controller action
    *
    * @return \Magento\Framework\Controller\ResultInterface
    */
   public function execute()
   {
      try
      {
         $imageId = $this->_request->getParam('param_name', 'content_image');
         $result  = $this->imageUploader->saveFileToTmpDir($imageId);
         
         $result['cookie'] = [
            'name'      => $this->_getSession()->getName(),
            'value'     => $this->_getSession()->getSessionId(),
            'lifetime'  => $this->_getSession()->getCookieLifetime(),
            'path'      => $this->_getSession()->getCookiePath(),
            'domain'    => $this->_getSession()->getCookieDomain(),
         ];
      }
      catch (\Exception $e)
      {
         $result = ['error' => $e->getMessage(), 'errorcode' => $e->getCode()];
      }
      
      return $this->resultFactory->create(ResultFactory::TYPE_JSON)->setData($result);
   }
}
