<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Cms
 */

namespace Totem\Cms\Block;

use Magento\Store\Model\ScopeInterface;

class Page extends \Magento\Cms\Block\Page
{
   /**
    * Prepare breadcrumbs
    *
    * @param \Magento\Cms\Model\Page $page
    * @throws \Magento\Framework\Exception\LocalizedException
    * @return void
    */
   protected function _addBreadcrumbs(\Magento\Cms\Model\Page $page)
   {
      $showBreadcrumbs = $page->getShowBreadcrumbs();
      
      $homePageIdentifier = $this->_scopeConfig->getValue(
         'web/default/cms_home_page',
         ScopeInterface::SCOPE_STORE
      );
      $homePageDelimiterPosition = strrpos($homePageIdentifier, '|');
      if ($homePageDelimiterPosition) {
         $homePageIdentifier = substr($homePageIdentifier, 0, $homePageDelimiterPosition);
      }
      $noRouteIdentifier = $this->_scopeConfig->getValue(
         'web/default/cms_no_route',
         ScopeInterface::SCOPE_STORE
      );
      $noRouteDelimiterPosition = strrpos($noRouteIdentifier, '|');
      if ($noRouteDelimiterPosition) {
         $noRouteIdentifier = substr($noRouteIdentifier, 0, $noRouteDelimiterPosition);
      }
      if ($this->_scopeConfig->getValue('web/default/show_cms_breadcrumbs', ScopeInterface::SCOPE_STORE)
          && ($breadcrumbsBlock = $this->getLayout()->getBlock('breadcrumbs'))
          && $page->getIdentifier() !== $homePageIdentifier
          && $page->getIdentifier() !== $noRouteIdentifier
          && $showBreadcrumbs
      ) {
         $breadcrumbsBlock->addCrumb(
            'home',
            [
               'label' => __('Home'),
               'title' => __('Go to Home Page'),
               'link' => $this->_storeManager->getStore()->getBaseUrl()
            ]
         );
         $breadcrumbsBlock->addCrumb('cms_page', ['label' => $page->getTitle(), 'title' => $page->getTitle()]);
      }
   }
}