<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Cms
 */

namespace Totem\Cms\Block;

use Totem\Cms\Helper\Data as CmsHelper;

class Block extends \Magento\Cms\Block\Block
{
   /**
    * @var CmsHelper
    */
   protected $cmsHelper;
   
   /**
    * Construct
    *
    * @param \Magento\Framework\View\Element\Context $context
    * @param \Magento\Cms\Model\Template\FilterProvider $filterProvider
    * @param \Magento\Store\Model\StoreManagerInterface $storeManager
    * @param \Magento\Cms\Model\BlockFactory $blockFactory
    * @param CmsHelper $cmsHelper
    * @param array $data
    */
   public function __construct(
      \Magento\Framework\View\Element\Context $context,
      \Magento\Cms\Model\Template\FilterProvider $filterProvider,
      \Magento\Store\Model\StoreManagerInterface $storeManager,
      \Magento\Cms\Model\BlockFactory $blockFactory,
      CmsHelper $cmsHelper,
      array $data = []
   ) {
      parent::__construct($context, $filterProvider, $storeManager, $blockFactory, $data);
      
      $this->cmsHelper = $cmsHelper;
   }
   
   /**
    * Prepare Content HTML
    *
    * @return string
    */
   protected function _toHtml()
   {
      $blockId = $this->getBlockId();
      $html    = '';
      if ($blockId):
         $storeId = $this->_storeManager->getStore()->getId();
         /** @var \Magento\Cms\Model\Block $block */
         $block = $this->_blockFactory->create();
         $block->setStoreId($storeId)->load($blockId);
         if ($block->isActive() && $this->cmsHelper->isBlockVisible($block)):
            $html = $this->_filterProvider->getBlockFilter()->setStoreId($storeId)->filter($block->getContent());
         endif;
      endif;
      
      return $html;
   }
}