/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2019 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Catalog
 */

define([
   'Magento_Ui/js/grid/columns/column',
   'Magento_Catalog/js/product/list/column-status-validator'
], function (Column, columnStatusValidator) {
   'use strict';

   return Column.extend({
      /**
       * Depends on this option, view product button can be shown or hide. Depends on backend configuration
       *
       * @returns {Boolean}
       */
      isAllowed: function () {
         return columnStatusValidator.isValid(this.source(), 'view_product', 'show_buttons');
      },
   
      /**
        * Get button label.
        *
        * @return {String}
        */
      getLabel: function () {
         return this.label;
      }
   });
});
