<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Catalog
 */

namespace Totem\Catalog\Setup;

use Magento\Eav\Setup\EavSetupFactory;
use Magento\Framework\Setup\UpgradeDataInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;

/**
 * @codeCoverageIgnore
 */
class UpgradeData implements UpgradeDataInterface
{
   /**
    * Eav Setup Factory.
    *
    * @var EavSetupFactory
    */
   private $eavSetupFactory;
   
   /**
    * Init.
    *
    * @param EavSetupFactory $eavSetupFactory
    */
   public function __construct(
      EavSetupFactory $eavSetupFactory
   ) {
      $this->eavSetupFactory = $eavSetupFactory;
   }
   
   /**
    * {@inheritdoc}
    *
    * @SuppressWarnings(PHPMD.ExcessiveMethodLength)
    */
   public function upgrade(
      ModuleDataSetupInterface $setup,
      ModuleContextInterface $context
   ) {
      /** @var EavSetupFactory $eavSetup */
      $eavSetup = $this->eavSetupFactory->create(['setup' => $setup]);
   
      if (version_compare($context->getVersion(), '0.0.3') < 0):
         $eavSetup->addAttribute(
            \Magento\Catalog\Model\Product::ENTITY,
            'store_only',
            [
               'type'                     => 'int',
               'backend'                  => '',
               'frontend'                 => '',
               'label'                    => 'Store Only',
               'input'                    => 'boolean',
               'class'                    => '',
               'source'                   => 'Magento\Eav\Model\Entity\Attribute\Source\Boolean',
               'global'                   => \Magento\Catalog\Model\ResourceModel\Eav\Attribute::SCOPE_GLOBAL,
               'visible'                  => true,
               'required'                 => false,
               'user_defined'             => true,
               'default'                  => 0,
               'searchable'               => false,
               'filterable'               => false,
               'comparable'               => false,
               'visible_on_front'         => false,
               'used_in_product_listing'  => true,
               'unique'                   => false,
               'apply_to'                 => ''
            ]
         );
      endif;
   }
}