<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Catalog
 */

namespace Totem\Catalog\Setup;

use Magento\Eav\Setup\EavSetupFactory;
use Magento\Framework\Setup\InstallDataInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;

/**
 * @codeCoverageIgnore
 */
class InstallData implements InstallDataInterface
{
   /**
    * Eav Setup Factory.
    *
    * @var EavSetupFactory
    */
   private $eavSetupFactory;
   
   /**
    * Init.
    *
    * @param EavSetupFactory $eavSetupFactory
    */
   public function __construct(
      EavSetupFactory $eavSetupFactory
   ) {
      $this->eavSetupFactory = $eavSetupFactory;
   }
   
   /**
    * {@inheritdoc}
    *
    * @SuppressWarnings(PHPMD.ExcessiveMethodLength)
    */
   public function install(
      ModuleDataSetupInterface $setup,
      ModuleContextInterface $context
   ) {
      $setup->startSetup();
      
      /** @var EavSetupFactory $eavSetup */
      $eavSetup = $this->eavSetupFactory->create(['setup' => $setup]);
   
      $eavSetup->addAttribute(
         \Magento\Catalog\Model\Category::ENTITY, 'image_icon', [
            'type'         => 'varchar',
            'label'        => 'Category icon',
            'input'        => 'image',
            'backend'      => \Magento\Catalog\Model\Category\Attribute\Backend\Image::class,
            'required'     => false,
            'sort_order'   => 5,
            'global'       => \Magento\Eav\Model\Entity\Attribute\ScopedAttributeInterface::SCOPE_STORE,
            'group'        => 'General Information',
         ]
      );
   
      $setup->endSetup();
   }
}