<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Catalog
 */

namespace Totem\Catalog\Plugin;

class ProductPlugin
{
   /**
    * If product is only available in store, then make it not saleable
    *
    * @param \Magento\Catalog\Model\Product $product
    * @param $isSaleable
    *
    * @return bool
    */
   public function afterIsSaleable(\Magento\Catalog\Model\Product $product, $isSaleable)
   {
      if($product->getStoreOnly()):
         return false;
      endif;
      
      return $isSaleable;
   }
}