<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2020 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Catalog
 * @comment    Added stock attributes for the different simple products
 */

namespace Totem\Catalog\Plugin\ConfigurableProduct\Product\View\Type;

use Magento\Framework\Serialize\Serializer\Json;
use Magento\Catalog\Api\ProductRepositoryInterface;
use Totem\Catalog\Helper\Data as CatalogHelper;

class Configurable
{
   /**
    * @var Json
    */
   protected $serializer;
   
   /**
    * @var ProductRepositoryInterface
    */
   protected $productRepository;
   
   /**
    * @var CatalogHelper
    */
   public $catalogHelper;
   
   /**
    * @param Json $serializer
    * @param ProductRepositoryInterface $productRepository
    * @param CatalogHelper $catalogHelper
    */
   public function __construct(
      Json $serializer,
      ProductRepositoryInterface $productRepository,
      CatalogHelper $catalogHelper
   ) {
      $this->serializer          = $serializer;
      $this->productRepository   = $productRepository;
      $this->catalogHelper       = $catalogHelper;
   }
   
   /**
    * @param $id
    *
    * @return \Magento\Catalog\Api\Data\ProductInterface
    * @throws \Magento\Framework\Exception\NoSuchEntityException
    */
   public function getProductById($id)
   {
      return $this->productRepository->getById($id);
   }
   
   /**
    * @param \Magento\ConfigurableProduct\Block\Product\View\Type\Configurable $subject
    * @param \Closure                                                          $proceed
    *
    * @return bool|string
    * @throws \Magento\Framework\Exception\NoSuchEntityException
    */
   public function aroundGetJsonConfig(\Magento\ConfigurableProduct\Block\Product\View\Type\Configurable $subject, \Closure $proceed)
   {
      $config = $proceed();
      
      if(!$this->catalogHelper->getConfig('totem_catalog/stock_message/update_swatch_stock', true)):
         return $config;
      endif;
      
      $stock  = [];
      $config = $this->serializer->unserialize($config);
      
      foreach ($subject->getAllowProducts() as $_product):
         $id               = $_product->getId();
         $product          = $this->getProductById($id);
   
         $stockItem        = $product->getExtensionAttributes()->getStockItem();
         
         $stock[$id]       = [
            'qty'       => intval($stockItem->getQty()),
            'backorder' => $stockItem->getBackorders()
         ];
      endforeach;
      
      $config['stock'] = $stock;
      
      return $this->serializer->serialize($config);
   }
}
