<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Catalog
 */

namespace Totem\Catalog\Plugin\Category\Attribute\Source;

class Mode
{
   /**
    * Add multiple display modes to the categories
    */
   public function afterGetAllOptions(\Magento\Catalog\Model\Category\Attribute\Source\Mode $subject, $result)
   {
      $highest = max(array_keys($result));
      $result[$highest + 1] = $result[2];
      unset($result[2]);
   
      $result[2]  = ['value' => \Totem\Catalog\Block\Category\View::DM_SUBCATEGORIES,           'label' => __('Subcategories only')];
      $result[]   = ['value' => \Totem\Catalog\Block\Category\View::DM_SUBCATEGORIES_PRODUCTS,  'label' => __('Subcategories and products')];
      $result[]   = ['value' => \Totem\Catalog\Block\Category\View::DM_SUBCATEGORIES_PAGE,      'label' => __('Static block and subcategories')];
      $result[]   = ['value' => \Totem\Catalog\Block\Category\View::DM_SUBCATEGORIES_MIXED,     'label' => __('Static block, subcategories and products')];
   
      ksort($result);
      
      return $result;
   }
}