<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Catalog
 */

namespace Totem\Catalog\Block\Product;

class Discount extends \Magento\Catalog\Block\Product\View
{
   /**
    * Retrieve the discount
    *
    * @return float
    */
   public function getDiscount()
   {
      if (!$product = $this->getProduct()):
         return false;
      endif;
   
      $originalPrice = $product->getPrice();
      $finalPrice    = $product->getFinalPrice();
   
      if ($originalPrice <= $finalPrice):
         return false;
      endif;

      $discount = $originalPrice - $finalPrice;
         
      return $discount;
   }
   
   /**
    * Retrieve the percentage
    *
    * @return string
    */
   public function getPercentage($discount)
   {
      return number_format($discount * 100 / $this->getProduct()->getPrice(), 0);
   }
}