<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Catalog
 */

namespace Totem\Catalog\Block\Category;

use Magento\Catalog\Model\ResourceModel\Category\CollectionFactory as CategoryCollectionFactory;

class View extends \Magento\Catalog\Block\Category\View
{
   /**
    * @var CategoryCollectionFactory
    */
   protected $categoryFactory;
   
   /**
    * @param \Magento\Framework\View\Element\Template\Context $context
    * @param \Magento\Catalog\Model\Layer\Resolver $layerResolver
    * @param \Magento\Framework\Registry $registry
    * @param \Magento\Catalog\Helper\Category $categoryHelper
    * @param CategoryCollectionFactory $categoryFactory
    * @param array $data
    */
   public function __construct(
      \Magento\Framework\View\Element\Template\Context $context,
      \Magento\Catalog\Model\Layer\Resolver $layerResolver,
      \Magento\Framework\Registry $registry,
      \Magento\Catalog\Helper\Category $categoryHelper,
      CategoryCollectionFactory $categoryFactory,
      array $data = []
   ) {
      parent::__construct($context, $layerResolver, $registry, $categoryHelper, $data);
      
      $this->categoryFactory = $categoryFactory;
   }
   
   /**#@+
    * Category display modes
    */
   const DM_SUBCATEGORIES = 'SUBCATEGORIES';
   
   const DM_SUBCATEGORIES_PRODUCTS = 'SUBCATEGORIES_AND_PRODUCTS';
   
   const DM_SUBCATEGORIES_PAGE = 'SUBCATEGORIES_AND_PAGE';
   
   const DM_SUBCATEGORIES_MIXED = 'SUBCATEGORIES_AND_PAGE_AND_PRODUCTS';
   /**#@-*/
   
   /**
    * Check if category display mode is "Subcategories only"
    *
    * @return bool
    */
   public function isSubcategoriesMode()
   {
      if($this->getCurrentCategory()->getDisplayMode() != self::DM_SUBCATEGORIES):
         return false;
      endif;
      
      $this->unsetProductLayout();
      
      return true;
   }
   
   /**
    * Check if category display mode is "Subcategories and products"
    *
    * @return bool
    */
   public function isSubcategoriesProductsMode()
   {
      return $this->getCurrentCategory()->getDisplayMode() == self::DM_SUBCATEGORIES_PRODUCTS;
   }
   
   /**
    * Check if category display mode is "Subcategories and static block"
    *    *
    * @return bool
    */
   public function isSubcategoriesContentMode()
   {
      if($this->getCurrentCategory()->getDisplayMode() != self::DM_SUBCATEGORIES_PAGE):
         return false;
      endif;
   
      $this->unsetProductLayout();
   
      return true;
   }
   
   /**
    * Check if category display mode is "Subcategories, static block and products"
    *
    * @return bool
    */
   public function isSubcategoriesMixedMode()
   {
      return $this->getCurrentCategory()->getDisplayMode() == self::DM_SUBCATEGORIES_MIXED;
   }
   
   /**
    * Check if category display mode is "Static Block Only"
    *
    * @return bool
    */
   public function isContentMode()
   {
      if($this->getCurrentCategory()->getDisplayMode() != \Magento\Catalog\Model\Category::DM_PAGE):
         return false;
      endif;
   
      $this->unsetProductLayout();
   
      return true;
   }
   
   /**
    * Remove all layout childs for products and sidebar when products not shown
    *
    * @return bool
    */
   public function unsetProductLayout()
   {
      $this->getLayout()->unsetChild('columns','div.sidebar.main');
      $this->getLayout()->unsetChild('columns','div.sidebar.additional');
      $this->getLayout()->unsetChild('columns','main');
      $this->getLayout()->unsetChild('main.content','columns');
   }
   
   /**
    * Get the subcategories for the current category
    *
    * @return mixed
    */
   public function getSubcategories()
   {
      $category      = $this->getCurrentCategory();
      $subcategories = $this->categoryFactory->create();
      $subcategories->addAttributeToSelect('url_key')
                    ->addAttributeToSelect('name')
                    ->addAttributeToSelect('image')
                    ->addAttributeToSelect('thumbnail')
                    ->addAttributeToSelect('image_icon')
                    ->addAttributeToFilter('is_active', 1)
                    ->addIdFilter($category->getChildren())
                    ->addUrlRewriteToResult()
                    ->setOrder('position', 'ASC');
   
      if(!$subcategories->getSize()):
         return false;
      endif;
      
      return $subcategories;
   }
}
