<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Catalog
 */

namespace Totem\Catalog\Block\Category;

/**
 * Html page title block
 *
 * @method $this setTitleId($titleId)
 * @method $this setTitleClass($titleClass)
 * @method string getTitleId()
 * @method string getTitleClass()
 * @api
 * @since 100.0.2
 */
class Title extends \Magento\Catalog\Block\Category\View
{
   /**
    * Own page title to display on the page
    *
    * @var string
    */
   protected $pageTitle;
   
   /**
    * Provide own page title or pick it from Head Block
    *
    * @return string
    */
   public function getPageTitle()
   {
      if (!empty($this->pageTitle)) {
         return $this->pageTitle;
      }
      return __($this->pageConfig->getTitle()->getShort());
   }
   
   /**
    * Provide own page content heading
    *
    * @return string
    */
   public function getPageHeading()
   {
      if (!empty($this->pageTitle)) {
         return __($this->pageTitle);
      }
      return __($this->pageConfig->getTitle()->getShortHeading());
   }
   
   /**
    * Set own page title
    *
    * @param string $pageTitle
    * @return void
    */
   public function setPageTitle($pageTitle)
   {
      $this->pageTitle = $pageTitle;
   }
}
