<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_BugFixes
 * @comment    Bugfix: Allow symlinks for module and theme files
 */

namespace Totem\BugFixes\Plugin\Magento\Framework\View\Element\Template\File;

class Validator
{
   /**
    * @var \Magento\Framework\App\State
    */
   protected $appState;
   
   /**
    * Validator constructor.
    *
    * @param \Magento\Framework\App\State $appState
    */
   public function __construct(
      \Magento\Framework\App\State $appState
   ) {
      $this->appState = $appState;
   }
   
   /**
    * @param $subject
    * @param $result
    *
    * @return bool
    */
   public function afterIsValid($subject, $result)
   {
      if($this->appState->getMode() == \Magento\Framework\App\State::MODE_DEVELOPER):
         $result = true;
      endif;
      
      return $result;
   }
}