<?php
/**
 * @author     Koen Slagter
 * @company    Abovo Media
 * @copyright  Copyright (c) 2018 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_BugFixes
 * @comment    Magento started building the breadcrumbs of the product pages based on the top-menu navigation using JS.
 *             When a custom menu is selected as top-menu, the breadcrumbs aren't working anymore
 */

namespace Totem\BugFixes\Block\Html;

class Breadcrumbs extends \Magento\Theme\Block\Html\Breadcrumbs
{
   /**
    * @return array
    */
   public function getCrumbs()
   {
      return $this->_crumbs;
   }
   
   /**
    * @return string
    *
    * @throws \Magento\Framework\Exception\NoSuchEntityException
    */
   public function getBaseUrl()
   {
      return $this->_storeManager->getStore()->getBaseUrl();
   }
}