/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2019 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Banner
 */

define([
          'jquery',
          'uiRegistry',
          'mage/translate',
          'Magento_Ui/js/form/element/abstract'
       ], function ($, uiRegistry, $t, Abstract) {
   'use strict';
   
   return Abstract.extend({
     /**
      * Initialize field component and proces dependency
      */
     initialize: function() {
        this._super();
        
        this.processVideoUrl(this.initialValue);
     },
     
     /**
      * @param {String} value
      */
     onUpdate: function (value) {
        this.processVideoUrl(value);
     },
   
     /**
      * Get video data
      *
      * @param url
      */
     processVideoUrl: function (url) {
        var that = this;

        setTimeout(function(){
           if (url.includes('youtu')|url.includes('vimeo')) {
              $.getJSON('https://noembed.com/embed', {
                 format: 'json',
                 url: url
              }, function(data) {
                 if(data.title) {
                    $('div[data-index="video"] .admin__field-note').html('<h3>' + data.title + '</h3><br />' + data.html);
                    uiRegistry.get('index = video_json').value(JSON.stringify(data));
                 }
                 else {
                    $('div[data-index="video"] .admin__field-note').html($t('Please fill in a (valid) YouTube or Vimeo video URL'));
                    uiRegistry.get('index = video_json').value('');
                 }
              });
           }
           else {
              $('div[data-index="video"] .admin__field-note').html($t('Please fill in a (valid) YouTube or Vimeo video URL'));
              uiRegistry.get('index = video_json').value('');
           }
        }, 100);

        return this;
     }
  });
});
