/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2019 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Banner
 */

define([
          'jquery',
          'underscore',
          'uiRegistry',
          'Magento_Ui/js/form/element/select'
       ], function ($, _, uiRegistry, select) {
   
   'use strict';
   
   return select.extend({
      /**
       * Array of field names that depend on the value of this UI component
       */
      dependentFieldNames: [
         'video'
      ],
      
      /**
       * Initialize field component and proces dependency
       */
      initialize: function() {
         this._super();
   
         this.processDependentFieldVisibility(this.initialValue);
      },
   
      /**
       * On value change handler.
       *
       * @param {String} value
       */
      onUpdate: function (value) {
         this.processDependentFieldVisibility(value);
         
         return this._super();
      },
   
      /**
       * Shows or hides dependent fields.
       *
       * @param value
       */
      processDependentFieldVisibility: function (value) {
         var that = this;
   
         setTimeout(function(){
            $.each(that.dependentFieldNames, function(dependentFieldIndex, dependentFieldName) {
               var field = uiRegistry.get('index = ' + dependentFieldName);
               if (typeof field !== 'undefined') {
                  if(field.index == value) {
                     field.show();
                  }
                  else {
                     field.hide();
                  }
               }
            });
         }, 100);
         
         return this;
      }
   });
});