<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Banner
 */

namespace Totem\Banner\Ui\Component\Listing\Column;

use Magento\Framework\UrlInterface;
use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Framework\View\Element\UiComponentFactory;
use Magento\Ui\Component\Listing\Columns\Column;
use Magento\Framework\App\ObjectManager;
use Magento\Framework\Escaper;

/**
 * Class BannerActions
 */
class BannerActions extends Column
{
   /**
    * Url path
    */
   const URL_PATH_EDIT     = 'totem_banner/banner/edit';
   const URL_PATH_DELETE   = 'totem_banner/banner/delete';
   const URL_PATH_DETAILS  = 'totem_banner/banner/details';
   
   /**
    * @var UrlInterface
    */
   protected $urlBuilder;
   
   /**
    * @var Escaper
    */
   private $escaper;
   
   /**
    * Constructor
    *
    * @param ContextInterface $context
    * @param UiComponentFactory $uiComponentFactory
    * @param UrlInterface $urlBuilder
    * @param array $components
    * @param array $data
    */
   public function __construct(
      ContextInterface $context,
      UiComponentFactory $uiComponentFactory,
      UrlInterface $urlBuilder,
      array $components = [],
      array $data = []
   ) {
      $this->urlBuilder = $urlBuilder;
      parent::__construct($context, $uiComponentFactory, $components, $data);
   }
   
   /**
    * Prepare Data Source
    *
    * @param array $dataSource
    * @return array
    */
   public function prepareDataSource(array $dataSource)
   {
      if (isset($dataSource['data']['items'])):
         foreach ($dataSource['data']['items'] as & $item):
            if (isset($item['banner_id'])):
               $title = $this->getEscaper()->escapeHtml($item['title']);
               $item[$this->getData('name')] = [
                  'edit' => [
                     'href' => $this->urlBuilder->getUrl(
                        static::URL_PATH_EDIT,
                        [
                           'banner_id' => $item['banner_id']
                        ]
                     ),
                     'label' => __('Edit')
                  ],
                  'delete' => [
                     'href' => $this->urlBuilder->getUrl(
                        static::URL_PATH_DELETE,
                        [
                           'banner_id' => $item['banner_id']
                        ]
                     ),
                     'label' => __('Delete'),
                     'confirm' => [
                        'title' => __('Delete %1', $title),
                        'message' => __('Are you sure you want to delete a %1 banner?', $title)
                     ]
                  ]
               ];
            endif;
         endforeach;
      endif;
      
      return $dataSource;
   }
   
   /**
    * Get instance of escaper
    * @return Escaper
    * @deprecated 101.0.7
    */
   private function getEscaper()
   {
      if (!$this->escaper):
         $this->escaper = ObjectManager::getInstance()->get(Escaper::class);
      endif;
      
      return $this->escaper;
   }
}
