<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Banner
 */

namespace Totem\Banner\Setup;

use Magento\Framework\Setup\UpgradeSchemaInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\Setup\ModuleContextInterface;

/**
 * @codeCoverageIgnore
 */
class UpgradeSchema implements UpgradeSchemaInterface
{
   /**
    * {@inheritdoc}
    * @SuppressWarnings(PHPMD.ExcessiveMethodLength)
    */
   public function upgrade(SchemaSetupInterface $setup, ModuleContextInterface $context)
   {
      $setup->startSetup();
      
      if (version_compare($context->getVersion(), '0.0.5') < 0):
         $setup->getConnection()->addColumn(
            $setup->getTable('totem_banner'),
            'identifier',
            [
               'type'      => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
               'length'    => 255,
               'nullable'  => false,
               'comment'   => 'Identifier',
               'after'     => 'banner_id'
            ]
         );
      endif;
      
      if (version_compare($context->getVersion(), '0.0.8') < 0):
         $setup->getConnection()->addColumn(
            $setup->getTable('totem_banner'),
            'content',
            [
               'type'      => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
               'length'    => '2M',
               'nullable'  => false,
               'comment'   => 'Content',
               'after'     => 'image'
            ]
         );
      endif;
      
      if (version_compare($context->getVersion(), '1.0.2') < 0):
         $setup->getConnection()->addColumn(
            $setup->getTable('totem_banner'),
            'link_new_window',
            [
               'type'      => \Magento\Framework\DB\Ddl\Table::TYPE_SMALLINT,
               'default'   => '0',
               'nullable'  => false,
               'comment'   => 'Open Link in New Window',
               'after'     => 'link_custom'
            ]
         );
      endif;
      
      if (version_compare($context->getVersion(), '1.0.5') < 0):
         $setup->getConnection()->addColumn(
            $setup->getTable('totem_banner'),
            'type',
            [
               'type'      => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
               'length'    => 100,
               'nullable'  => false,
               'comment'   => 'Banner Type',
               'after'     => 'button_label'
            ]
         );
   
         $setup->getConnection()->addColumn(
            $setup->getTable('totem_banner'),
            'video',
            [
               'type'      => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
               'length'    => 255,
               'nullable'  => true,
               'comment'   => 'Video',
               'after'     => 'image'
            ]
         );
   
         $setup->getConnection()->addColumn(
            $setup->getTable('totem_banner'),
            'video_json',
            [
               'type'      => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
               'length'    => '2M',
               'nullable'  => true,
               'comment'   => 'Video json',
               'after'     => 'video'
            ]
         );
      endif;
      
      $setup->endSetup();
   }
}
