<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Banner
 */

namespace Totem\Banner\Setup;

use Magento\Framework\Setup\InstallSchemaInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\DB\Adapter\AdapterInterface;

/**
 * @codeCoverageIgnore
 */
class InstallSchema implements InstallSchemaInterface
{
   /**
    * {@inheritdoc}
    * @SuppressWarnings(PHPMD.ExcessiveMethodLength)
    */
   public function install(SchemaSetupInterface $setup, ModuleContextInterface $context)
   {
      $installer = $setup;
      
      $installer->startSetup();
      
      /**
       * Create table 'totem_banner'
       */
      $table = $installer->getConnection()->newTable(
         $installer->getTable('totem_banner')
      )->addColumn(
         'banner_id',
         \Magento\Framework\DB\Ddl\Table::TYPE_SMALLINT,
         null,
         ['identity' => true, 'nullable' => false, 'primary' => true],
         'Banner ID'
      )->addColumn(
         'title',
         \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
         255,
         ['nullable' => false],
         'Title'
      )->addColumn(
         'subtitle',
         \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
         255,
         ['nullable' => false],
         'Subtitle'
      )->addColumn(
         'link_type',
         \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
         255,
         ['nullable' => true],
         'Link Type'
      )->addColumn(
         'link_category',
         \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
         10,
         ['nullable' => true, 'unsigned' => true, 'default' => null],
         'Link Category'
      )->addColumn(
         'link_page',
         \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
         100,
         ['nullable' => true, 'default' => null],
         'Link Page'
      )->addColumn(
         'link_custom',
         \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
         255,
         ['nullable' => true, 'default' => null],
         'Link Custom'
      )->addColumn(
         'show_button',
         \Magento\Framework\DB\Ddl\Table::TYPE_SMALLINT,
         null,
         ['nullable' => false, 'default' => '0'],
         'Show Button'
      )->addColumn(
         'button_label',
         \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
         255,
         ['nullable' => false],
         'Button Label'
      )->addColumn(
         'image',
         \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
         255,
         ['nullable' => true],
         'Image'
      )->addColumn(
         'creation_time',
         \Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
         null,
         ['nullable' => false, 'default' => \Magento\Framework\DB\Ddl\Table::TIMESTAMP_INIT],
         'Creation Time'
      )->addColumn(
         'update_time',
         \Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
         null,
         ['nullable' => false, 'default' => \Magento\Framework\DB\Ddl\Table::TIMESTAMP_INIT_UPDATE],
         'Modification Time'
      )->addColumn(
         'is_active',
         \Magento\Framework\DB\Ddl\Table::TYPE_SMALLINT,
         null,
         ['nullable' => false, 'default' => '1'],
         'Is Banner Active'
      )->addIndex(
         $setup->getIdxName(
            $installer->getTable('totem_banner'),
            ['title', 'subtitle'],
            AdapterInterface::INDEX_TYPE_FULLTEXT
         ),
         ['title', 'subtitle'],
         ['type' => AdapterInterface::INDEX_TYPE_FULLTEXT]
      )->setComment(
         'Banner Table'
      );
      $installer->getConnection()->createTable($table);
      
      /**
       * Create table 'totem_banner_store'
       */
      $table = $installer->getConnection()->newTable(
         $installer->getTable('totem_banner_store')
      )->addColumn(
         'banner_id',
         \Magento\Framework\DB\Ddl\Table::TYPE_SMALLINT,
         null,
         ['nullable' => false, 'primary' => true],
         'Banner ID'
      )->addColumn(
         'store_id',
         \Magento\Framework\DB\Ddl\Table::TYPE_SMALLINT,
         null,
         ['unsigned' => true, 'nullable' => false, 'primary' => true],
         'Store ID'
      )->addIndex(
         $installer->getIdxName('totem_banner_store', ['store_id']),
         ['store_id']
      )->addForeignKey(
         $installer->getFkName('totem_banner_store', 'banner_id', 'totem_banner', 'banner_id'),
         'banner_id',
         $installer->getTable('totem_banner'),
         'banner_id',
         \Magento\Framework\DB\Ddl\Table::ACTION_CASCADE
      )->addForeignKey(
         $installer->getFkName('totem_banner_store', 'store_id', 'store', 'store_id'),
         'store_id',
         $installer->getTable('store'),
         'store_id',
         \Magento\Framework\DB\Ddl\Table::ACTION_CASCADE
      )->setComment(
         'Banner To Store Linkage Table'
      );
      $installer->getConnection()->createTable($table);
      
      $installer->endSetup();
   }
}
