<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2018 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Banner
 */

namespace Totem\Banner\Model\Source;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\ObjectManager;
use Magento\Framework\Serialize\Serializer\Json;

class CssClass implements \Magento\Framework\Option\ArrayInterface
{
   /**
    * @var Json
    */
   private $_serializer;
   
   /**
    * @var ScopeConfigInterface
    */
   private $_scopeConfig;
   
   /**
    * @param ScopeConfigInterface $scopeConfig
    * @param Json $serializer
    */
   public function __construct(
      ScopeConfigInterface $scopeConfig,
      Json $serializer = null
   )
   {
      $this->_scopeConfig  = $scopeConfig;
      $this->_serializer   = $serializer ?: ObjectManager::getInstance()->get(Json::class);
   }
   
   /**
    * @return array
    */
   public function toOptionArray()
   {
      $options = $this->getCssClasses();
      array_unshift($options, ['value' => '', 'label' => __('None')]);
   
      return $options;
   }
   
   /**
    * Retrieve the css classes
    *
    * @return array
    */
   public function getCssClasses()
   {
      $values = $this->_scopeConfig->getValue('totem_banner/general/css_classes');
      if(!$values):
         return [];
      endif;
      
      $values = $this->_serializer->unserialize($values);
      if(!is_array($values) || count($values) < 1):
         return [];
      endif;
      
      $options = [];
      foreach($values as $value):
         $options[] = ['value' => $value['css_class'], 'label' => $value['css_label']];
      endforeach;
      
      return $options;
   }
}