<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Banner
 */

namespace Totem\Banner\Model\ResourceModel\Banner\Relation\Store;

use Magento\Framework\EntityManager\Operation\ExtensionInterface;
use Totem\Banner\Api\Data\BannerInterface;
use Totem\Banner\Model\ResourceModel\Banner;
use Magento\Framework\EntityManager\MetadataPool;

/**
 * Class SaveHandler
 */
class SaveHandler implements ExtensionInterface
{
   /**
    * @var MetadataPool
    */
   protected $metadataPool;
   
   /**
    * @var Banner
    */
   protected $resourceBanner;
   
   /**
    * @param MetadataPool $metadataPool
    * @param Banner $resourceBanner
    */
   public function __construct(
      MetadataPool $metadataPool,
      Banner $resourceBanner
   ) {
      $this->metadataPool = $metadataPool;
      $this->resourceBanner = $resourceBanner;
   }
   
   /**
    * @param object $entity
    * @param array $arguments
    * @return object
    * @throws \Exception
    */
   public function execute($entity, $arguments = [])
   {
      $entityMetadata = $this->metadataPool->getMetadata(BannerInterface::class);
      $linkField = $entityMetadata->getLinkField();
      
      $connection = $entityMetadata->getEntityConnection();
      
      $oldStores = $this->resourceBanner->lookupStoreIds((int)$entity->getId());
      $newStores = (array)$entity->getStores();
      
      $table = $this->resourceBanner->getTable('totem_banner_store');
      
      $delete = array_diff($oldStores, $newStores);
      if ($delete):
         $where = [
            $linkField . ' = ?' => (int)$entity->getData($linkField),
            'store_id IN (?)' => $delete,
         ];
         $connection->delete($table, $where);
      endif;
      
      $insert = array_diff($newStores, $oldStores);
      if ($insert):
         $data = [];
         foreach ($insert as $storeId):
            $data[] = [
               $linkField => (int)$entity->getData($linkField),
               'store_id' => (int)$storeId,
            ];
         endforeach;
         $connection->insertMultiple($table, $data);
      endif;
      
      return $entity;
   }
}
