<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Banner
 */

namespace Totem\Banner\Model\ResourceModel\Banner\Relation\Store;

use Totem\Banner\Model\ResourceModel\Banner;
use Magento\Framework\EntityManager\Operation\ExtensionInterface;

/**
 * Class ReadHandler
 */
class ReadHandler implements ExtensionInterface
{
   /**
    * @var Banner
    */
   protected $resourceBanner;
   
   /**
    * @param Banner $resourceBanner
    */
   public function __construct(
      Banner $resourceBanner
   ) {
      $this->resourceBanner = $resourceBanner;
   }
   
   /**
    * @param object $entity
    * @param array $arguments
    * @return object
    * @SuppressWarnings(PHPMD.UnusedFormalParameter)
    */
   public function execute($entity, $arguments = [])
   {
      if ($entity->getId()):
         $stores = $this->resourceBanner->lookupStoreIds((int)$entity->getId());
         $entity->setData('store_id', $stores);
         $entity->setData('stores', $stores);
      endif;
      
      return $entity;
   }
}
