<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Banner
 */

namespace Totem\Banner\Model\ResourceModel\Banner;

use Totem\Banner\Api\Data\BannerInterface;
use \Totem\Banner\Model\ResourceModel\AbstractCollection;

/**
 * Banner Collection
 */
class Collection extends AbstractCollection
{
   /**
    * @var string
    */
   protected $_idFieldName = 'banner_id';
   
   /**
    * Perform operations after collection load
    *
    * @return $this
    */
   protected function _afterLoad()
   {
      $entityMetadata = $this->metadataPool->getMetadata(BannerInterface::class);
      
      $this->performAfterLoad('totem_banner_store', $entityMetadata->getLinkField());
      
      return parent::_afterLoad();
   }
   
   /**
    * Define resource model
    *
    * @return void
    */
   protected function _construct()
   {
      $this->_init(\Totem\Banner\Model\Banner::class, \Totem\Banner\Model\ResourceModel\Banner::class);
      $this->_map['fields']['store'] = 'store_table.store_id';
      $this->_map['fields']['banner_id'] = 'main_table.banner_id';
   }
   
   /**
    * Returns pairs banner_id - title
    *
    * @return array
    */
   public function toOptionArray()
   {
      return $this->_toOptionArray('banner_id', 'title');
   }
   
   /**
    * Add filter by store
    *
    * @param int|array|\Magento\Store\Model\Store $store
    * @param bool $withAdmin
    * @return $this
    */
   public function addStoreFilter($store, $withAdmin = true)
   {
      $this->performAddStoreFilter($store, $withAdmin);
      
      return $this;
   }
   
   /**
    * Join store relation table if there is store filter
    *
    * @return void
    */
   protected function _renderFiltersBefore()
   {
      $entityMetadata = $this->metadataPool->getMetadata(BannerInterface::class);
      $this->joinStoreRelationTable('totem_banner_store', $entityMetadata->getLinkField());
   }
}
