<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Banner
 */

namespace Totem\Banner\Model\Banner\Source;

use Magento\Framework\Data\OptionSourceInterface;

/**
 * Class LinkType
 */
class LinkType implements OptionSourceInterface
{
   /**
    * Return array of options as value-label pairs
    *
    * @return array Format: array(array('value' => '<value>', 'label' => '<label>'), ...)
    */
   public function toOptionArray()
   {
      $options = [
         ['label' => __('No Link'),    'value' => 'no_link'],
         ['label' => __('Category'),   'value' => 'link_category'],
         ['label' => __('Page'),       'value' => 'link_page'],
         ['label' => __('Custom'),     'value' => 'link_custom']
      ];
      
      return $options;
   }
   
   /**
    * Get options
    *
    * @return array
    */
   public function getOptions()
   {
      $options = [
         'no_link'         => __('No Link'),
         'link_category'   => __('Category'),
         'link_page'       => __('Page'),
         'link_custom'     => __('Custom')
      ];
      
      return $options;
   }
}
