<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Banner
 */

namespace Totem\Banner\Model\Banner\Source;

use Magento\Framework\Data\OptionSourceInterface;

/**
 * Class IsActive
 */
class IsActive implements OptionSourceInterface
{
   /**
    * @var \Totem\Banner\Model\Banner
    */
   protected $banner;
   
   /**
    * Constructor
    *
    * @param \Totem\Banner\Model\Banner $banner
    */
   public function __construct(\Totem\Banner\Model\Banner $banner)
   {
      $this->banner = $banner;
   }
   
   /**
    * Get options
    *
    * @return array
    */
   public function toOptionArray()
   {
      $availableOptions = $this->banner->getAvailableStatuses();
      $options = [];
      foreach ($availableOptions as $key => $value) {
         $options[] = [
            'label' => $value,
            'value' => $key,
         ];
      }
      return $options;
   }
}
