<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Banner
 */

namespace Totem\Banner\Model\Banner\Source;

use Magento\Framework\Data\OptionSourceInterface;
use Magento\Cms\Model\ResourceModel\Page\CollectionFactory as PageCollection;

/**
 * Class CmsPages
 */
class CmsPages implements OptionSourceInterface
{
   /**
    * @var PageCollection
    */
   protected $pageCollection;
   
   /**
    * @param PageCollection $pageCollection
    */
   public function __construct(
      PageCollection $pageCollection
   ) {
      $this->pageCollection = $pageCollection;
   }
   
   /**
    * Get options
    *
    * @return array
    */
   public function toOptionArray()
   {
      $collection = $this->pageCollection->create()
                                         ->addFieldToSelect('title')
                                         ->addFieldToSelect('identifier')
                                         ->addFieldToSelect('is_active');
      
      $options   = [];
      foreach ($collection as $page):
         if ($page->getTitle() && $page->getIdentifier()):
            $suffix = '';
            if (!$page->getIsActive()):
               $suffix = __(' (Inactive)');
            endif;
            
            $options[] = [
               'value' => $page->getIdentifier(),
               'label' => __($page->getTitle()) . $suffix
            ];
         endif;
      endforeach;
      
      return $options;
   }
}
