<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Banner
 */

namespace Totem\Banner\Model\Banner;

use Totem\Banner\Model\ResourceModel\Banner\CollectionFactory;
use Magento\Framework\App\Request\DataPersistorInterface;
use Totem\Banner\Model\Banner\FileInfo;

/**
 * Class DataProvider
 */
class DataProvider extends \Magento\Ui\DataProvider\AbstractDataProvider
{
   /**
    * @var \Totem\Banner\Model\ResourceModel\Banner\Collection
    */
   protected $collection;
   
   /**
    * @var DataPersistorInterface
    */
   protected $dataPersistor;
   
   /**
    * @var array
    */
   protected $loadedData;
   
   /**
    * @var FileInfo
    */
   private $fileInfo;
   
   /**
    * Constructor
    *
    * @param string $name
    * @param string $primaryFieldName
    * @param string $requestFieldName
    * @param CollectionFactory $bannerCollectionFactory
    * @param DataPersistorInterface $dataPersistor
    * @param FileInfo $fileInfo
    * @param array $meta
    * @param array $data
    */
   public function __construct(
      $name,
      $primaryFieldName,
      $requestFieldName,
      CollectionFactory $bannerCollectionFactory,
      DataPersistorInterface $dataPersistor,
      FileInfo $fileInfo,
      array $meta = [],
      array $data = []
   ) {
      $this->collection    = $bannerCollectionFactory->create();
      $this->dataPersistor = $dataPersistor;
      $this->fileInfo      = $fileInfo;
      parent::__construct($name, $primaryFieldName, $requestFieldName, $meta, $data);
   }
   
   /**
    * Get data
    *
    * @return array
    */
   public function getData()
   {
      if (isset($this->loadedData)):
         return $this->loadedData;
      endif;
      
      $items = $this->collection->getItems();
      /** @var \Totem\Banner\Model\Banner $banner */
      foreach ($items as $banner):
         $bannerData          = $banner->getData();
         if($image = $bannerData['image']):
            if($this->fileInfo->isExist($image)):
               $stat = $this->fileInfo->getStat($image);
               $mime = $this->fileInfo->getMimeType($image);
               
               $bannerData['image'] = [
                  [
                     'name'   => $image,
                     'url'    => $banner->getImageUrl(),
                     'size'   => isset($stat) ? $stat['size'] : 0,
                     'type'   => $mime
                  ]
               ];
            endif;
         endif;
         
         $this->loadedData[$banner->getId()] = $bannerData;
      endforeach;
      
      $data = $this->dataPersistor->get('totem_banner');
      if (!empty($data)):
         $banner = $this->collection->getNewEmptyItem();
         $banner->setData($data);
         $this->loadedData[$banner->getId()] = $banner->getData();
         $this->dataPersistor->clear('totem_banner');
      endif;
      
      return $this->loadedData;
   }
}
