<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Banner
 */

namespace Totem\Banner\Controller\Adminhtml\Banner\Widget;

use Magento\Backend\App\Action;

class Chooser extends \Magento\Backend\App\Action
{
   /**
    * Authorization level of a basic admin session
    */
   const ADMIN_RESOURCE = 'Magento_Widget::widget_instance';
   
   /**
    * @var \Magento\Framework\View\LayoutFactory
    */
   protected $layoutFactory;
   
   /**
    * @var \Magento\Framework\Controller\Result\RawFactory
    */
   protected $resultRawFactory;
   
   /**
    * @param Action\Context $context
    * @param \Magento\Framework\Controller\Result\RawFactory $resultRawFactory
    * @param \Magento\Framework\View\LayoutFactory $layoutFactory
    */
   public function __construct(
      Action\Context $context,
      \Magento\Framework\Controller\Result\RawFactory $resultRawFactory,
      \Magento\Framework\View\LayoutFactory $layoutFactory
   ) {
      $this->layoutFactory    = $layoutFactory;
      $this->resultRawFactory = $resultRawFactory;
      
      parent::__construct($context);
   }
   
   /**
    * Chooser Source action
    *
    * @return \Magento\Framework\Controller\Result\Raw
    */
   public function execute()
   {
      $uniqId        = $this->getRequest()->getParam('uniq_id');
      
      /** @var \Magento\Framework\View\Layout $layout */
      $layout        = $this->layoutFactory->create();
      $bannersGrid   = $layout->createBlock(
         \Totem\Banner\Block\Adminhtml\Banner\Widget\Chooser::class,
         '',
         ['data' => ['id' => $uniqId]]
      );
      $html          = $bannersGrid->toHtml();
      
      /** @var \Magento\Framework\Controller\Result\Raw $resultRaw */
      $resultRaw     = $this->resultRawFactory->create();
      
      return $resultRaw->setContents($html);
   }
}
