<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Banner
 */

namespace Totem\Banner\Controller\Adminhtml\Banner;

use Magento\Backend\App\Action\Context;
use Totem\Banner\Model\Banner;
use Magento\Framework\App\Request\DataPersistorInterface;
use Magento\Framework\Exception\LocalizedException;

class Save extends \Totem\Banner\Controller\Adminhtml\Banner
{
   /**
    * @var DataPersistorInterface
    */
   protected $dataPersistor;
   
   /**
    * @var \Totem\Banner\Model\ImageUploader
    */
   public $imageUploader;
   
   /**
    * @param Context $context
    * @param \Magento\Framework\Registry $coreRegistry
    * @param DataPersistorInterface $dataPersistor
    * @param \Totem\Banner\Model\ImageUploader $imageUploader
    */
   public function __construct(
      Context $context,
      \Magento\Framework\Registry $coreRegistry,
      DataPersistorInterface $dataPersistor,
      \Totem\Banner\Model\ImageUploader $imageUploader
   ) {
      $this->dataPersistor = $dataPersistor;
      $this->imageUploader = $imageUploader;
      
      parent::__construct($context, $coreRegistry);
   }
   
   /**
    * Save action
    *
    * @SuppressWarnings(PHPMD.CyclomaticComplexity)
    * @return \Magento\Framework\Controller\ResultInterface
    */
   public function execute()
   {
      /** @var \Magento\Backend\Model\View\Result\Redirect $resultRedirect */
      $resultRedirect = $this->resultRedirectFactory->create();
      
      $data = $this->getRequest()->getPostValue();
      if ($data):
         $id = $this->getRequest()->getParam('banner_id');
         
         if (isset($data['is_active']) && $data['is_active'] === 'true'):
            $data['is_active'] = Banner::STATUS_ENABLED;
         endif;
         
         if (empty($data['banner_id'])):
            $data['banner_id'] = null;
         endif;
         
         /** @var \Totem\Banner\Model\Banner $model */
         $model = $this->_objectManager->create(\Totem\Banner\Model\Banner::class)->load($id);
         if (!$model->getId() && $id):
            $this->messageManager->addErrorMessage(__('This banner no longer exists.'));
            
            return $resultRedirect->setPath('*/*/');
         endif;
         
         $model->setData($data);
         
         $deleteImage = false;
         if (isset($data['image'])):
            if (isset($data['image']['delete']) && $data['image']['delete'] == '1'):
               unset($data['image']);
               
               $model->setData('image', '');
               $deleteImage = true;
            endif;
         endif;
         
         if ((!isset($data['image']) || (count($data['image']) == 1)) && !$deleteImage):
            $image = $this->imageUploader->uploadFileAndGetName('image', $data);
            if ($image === false):
               $this->messageManager->addErrorMessage(__('Please choose an image to upload.'));
               $resultRedirect->setPath(
                  '*/*/edit',
                  [
                     'post_id'  => $model->getId(),
                     '_current' => true
                  ]
               );
               
               return $resultRedirect;
            endif;
            
            $model->setData('image', $image);
         endif;
         
         try
         {
            $model->save();
            $this->messageManager->addSuccessMessage(__('You saved the banner.'));
            $this->dataPersistor->clear('totem_banner');
            
            if ($this->getRequest()->getParam('back')):
               return $resultRedirect->setPath('*/*/edit', ['banner_id' => $model->getId()]);
            endif;
            
            return $resultRedirect->setPath('*/*/');
         }
         catch (LocalizedException $e)
         {
            $this->messageManager->addErrorMessage($e->getMessage());
         }
         catch (\Exception $e)
         {
            $this->messageManager->addExceptionMessage($e, __('Something went wrong while saving the banner.'));
         }
         
         $this->dataPersistor->set('totem_banner', $data);
         
         return $resultRedirect->setPath('*/*/edit', ['banner_id' => $this->getRequest()->getParam('banner_id')]);
      endif;
      
      return $resultRedirect->setPath('*/*/');
   }
}
