<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Banner
 */

namespace Totem\Banner\Controller\Adminhtml\Banner;

class NewAction extends \Totem\Banner\Controller\Adminhtml\Banner
{
   /**
    * @var \Magento\Backend\Model\View\Result\ForwardFactory
    */
   protected $resultForwardFactory;
   
   /**
    * @param \Magento\Backend\App\Action\Context $context
    * @param \Magento\Framework\Registry $coreRegistry
    * @param \Magento\Backend\Model\View\Result\ForwardFactory $resultForwardFactory
    */
   public function __construct(
      \Magento\Backend\App\Action\Context $context,
      \Magento\Framework\Registry $coreRegistry,
      \Magento\Backend\Model\View\Result\ForwardFactory $resultForwardFactory
   ) {
      $this->resultForwardFactory = $resultForwardFactory;
      parent::__construct($context, $coreRegistry);
   }
   
   /**
    * Create new banner
    *
    * @return \Magento\Framework\Controller\ResultInterface
    */
   public function execute()
   {
      /** @var \Magento\Framework\Controller\Result\Forward $resultForward */
      $resultForward = $this->resultForwardFactory->create();
      
      return $resultForward->forward('edit');
   }
}
