<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Banner
 */

namespace Totem\Banner\Controller\Adminhtml\Banner;

use Magento\Framework\Controller\ResultFactory;
use Magento\Backend\App\Action\Context;
use Magento\Ui\Component\MassAction\Filter;
use Totem\Banner\Model\ResourceModel\Banner\CollectionFactory;

/**
 * Class MassDelete
 */
class MassDelete extends \Magento\Backend\App\Action
{
   /**
    * Authorization level of a basic admin session
    *
    * @see _isAllowed()
    */
   const ADMIN_RESOURCE = 'Totem_Banner::banner';
   
   /**
    * @var Filter
    */
   protected $filter;
   
   /**
    * @var CollectionFactory
    */
   protected $collectionFactory;
   
   /**
    * @param Context $context
    * @param Filter $filter
    * @param CollectionFactory $collectionFactory
    */
   public function __construct(Context $context, Filter $filter, CollectionFactory $collectionFactory)
   {
      $this->filter = $filter;
      $this->collectionFactory = $collectionFactory;
      
      parent::__construct($context);
   }
   
   /**
    * Execute action
    *
    * @return \Magento\Backend\Model\View\Result\Redirect
    * @throws \Magento\Framework\Exception\LocalizedException|\Exception
    */
   public function execute()
   {
      $collection = $this->filter->getCollection($this->collectionFactory->create());
      $collectionSize = $collection->getSize();
      
      foreach ($collection as $banner):
         $banner->delete();
      endforeach;
      
      $this->messageManager->addSuccessMessage(__('A total of %1 banner(s) have been deleted.', $collectionSize));
      
      /** @var \Magento\Backend\Model\View\Result\Redirect $resultRedirect */
      $resultRedirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
      
      return $resultRedirect->setPath('*/*/');
   }
}
