<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Banner
 */

namespace Totem\Banner\Controller\Adminhtml\Banner;

use Magento\Backend\App\Action\Context;
use Totem\Banner\Api\BannerRepositoryInterface as BannerRepository;
use Magento\Framework\Controller\Result\JsonFactory;
use Totem\Banner\Api\Data\BannerInterface;

class InlineEdit extends \Magento\Backend\App\Action
{
   /**
    * Authorization level of a basic admin session
    *
    * @see _isAllowed()
    */
   const ADMIN_RESOURCE = 'Totem_Banner::banner';
   
   /**
    * @var \Totem\Banner\Api\BannerRepositoryInterface
    */
   protected $bannerRepository;
   
   /**
    * @var \Magento\Framework\Controller\Result\JsonFactory
    */
   protected $jsonFactory;
   
   /**
    * @param Context $context
    * @param BannerRepository $bannerRepository
    * @param JsonFactory $jsonFactory
    */
   public function __construct(
      Context $context,
      BannerRepository $bannerRepository,
      JsonFactory $jsonFactory
   ) {
      parent::__construct($context);
      
      $this->bannerRepository = $bannerRepository;
      $this->jsonFactory      = $jsonFactory;
   }
   
   /**
    * @return \Magento\Framework\Controller\ResultInterface
    */
   public function execute()
   {
      /** @var \Magento\Framework\Controller\Result\Json $resultJson */
      $resultJson = $this->jsonFactory->create();
      $error = false;
      $messages = [];
      
      if ($this->getRequest()->getParam('isAjax')):
         $postItems = $this->getRequest()->getParam('items', []);
         if (!count($postItems)):
            $messages[] = __('Please correct the data sent.');
            $error = true;
         else:
            foreach (array_keys($postItems) as $bannerId):
               /** @var \Totem\Banner\Model\Banner $banner */
               $banner = $this->bannerRepository->getById($bannerId);
               try
               {
                  $banner->setData(array_merge($banner->getData(), $postItems[$bannerId]));
                  $this->bannerRepository->save($banner);
               }
               catch (\Exception $e)
               {
                  $messages[] = $this->getErrorWithBannerId(
                     $banner,
                     __($e->getMessage())
                  );
                  $error = true;
               }
            endforeach;
         endif;
      endif;
      
      return $resultJson->setData([
         'messages' => $messages,
         'error' => $error
      ]);
   }
   
   /**
    * Add banner title to error message
    *
    * @param BannerInterface $banner
    * @param string $errorText
    * @return string
    */
   protected function getErrorWithBannerId(BannerInterface $banner, $errorText)
   {
      return '[Banner ID: ' . $banner->getId() . '] ' . $errorText;
   }
}
