<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Banner
 */

namespace Totem\Banner\Controller\Adminhtml\Banner;

class Index extends \Totem\Banner\Controller\Adminhtml\Banner
{
   /**
    * @var \Magento\Framework\View\Result\PageFactory
    */
   protected $resultPageFactory;
   
   /**
    * @param \Magento\Backend\App\Action\Context $context
    * @param \Magento\Framework\Registry $coreRegistry
    * @param \Magento\Framework\View\Result\PageFactory $resultPageFactory
    */
   public function __construct(
      \Magento\Backend\App\Action\Context $context,
      \Magento\Framework\Registry $coreRegistry,
      \Magento\Framework\View\Result\PageFactory $resultPageFactory
   ) {
      $this->resultPageFactory = $resultPageFactory;
      
      parent::__construct($context, $coreRegistry);
   }
   
   /**
    * Index action
    *
    * @return \Magento\Framework\Controller\ResultInterface
    */
   public function execute()
   {
      /** @var \Magento\Backend\Model\View\Result\Page $resultPage */
      $resultPage = $this->resultPageFactory->create();
      $this->initPage($resultPage)->getConfig()->getTitle()->prepend(__('Banners'));
      
      $dataPersistor = $this->_objectManager->get(\Magento\Framework\App\Request\DataPersistorInterface::class);
      $dataPersistor->clear('totem_banner');
      
      return $resultPage;
   }
}
