<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Banner
 */

namespace Totem\Banner\Controller\Adminhtml\Banner\Image;

use Magento\Framework\Controller\ResultFactory;

/**
 * Class Upload
 */
class Upload extends \Magento\Backend\App\Action
{
   /**
    * Image uploader
    *
    * @var \Totem\Banner\Model\ImageUploader
    */
   protected $imageUploader;
   
   /**
    * Upload constructor.
    *
    * @param \Magento\Backend\App\Action\Context $context
    * @param \Totem\Banner\Model\ImageUploader $imageUploader
    */
   public function __construct(
      \Magento\Backend\App\Action\Context $context,
      \Totem\Banner\Model\ImageUploader $imageUploader
   ) {
      parent::__construct($context);
      
      $this->imageUploader = $imageUploader;
   }
   
   /**
    * Check admin permissions for this controller
    *
    * @return boolean
    */
   protected function _isAllowed()
   {
      return $this->_authorization->isAllowed('Totem_Banner::banner');
   }
   
   /**
    * Upload file controller action
    *
    * @return \Magento\Framework\Controller\ResultInterface
    */
   public function execute()
   {
      $imageId = $this->_request->getParam('param_name', 'image');
      
      try
      {
         $result = $this->imageUploader->saveFileToTmpDir($imageId);
         
         $result['cookie'] = [
            'name' => $this->_getSession()->getName(),
            'value' => $this->_getSession()->getSessionId(),
            'lifetime' => $this->_getSession()->getCookieLifetime(),
            'path' => $this->_getSession()->getCookiePath(),
            'domain' => $this->_getSession()->getCookieDomain(),
         ];
      }
      catch (\Exception $e)
      {
         $result = ['error' => $e->getMessage(), 'errorcode' => $e->getCode()];
      }
      
      return $this->resultFactory->create(ResultFactory::TYPE_JSON)->setData($result);
   }
}
