<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Banner
 */

namespace Totem\Banner\Controller\Adminhtml\Banner;

class Delete extends \Totem\Banner\Controller\Adminhtml\Banner
{
   /**
    * Delete action
    *
    * @return \Magento\Framework\Controller\ResultInterface
    */
   public function execute()
   {
      /** @var \Magento\Backend\Model\View\Result\Redirect $resultRedirect */
      $resultRedirect = $this->resultRedirectFactory->create();
      // check if we know what should be deleted
      $id = $this->getRequest()->getParam('banner_id');
      if ($id):
         try
         {
            // init model and delete
            $model = $this->_objectManager->create(\Totem\Banner\Model\Banner::class);
            $model->load($id);
            $model->delete();
            // display success message
            $this->messageManager->addSuccessMessage(__('You deleted the banner.'));
            
            // go to grid
            return $resultRedirect->setPath('*/*/');
         }
         catch (\Exception $e)
         {
            // display error message
            $this->messageManager->addErrorMessage($e->getMessage());
            
            // go back to edit form
            return $resultRedirect->setPath('*/*/edit', ['banner_id' => $id]);
         }
      endif;
      
      // display error message
      $this->messageManager->addErrorMessage(__('We can\'t find a banner to delete.'));
      
      // go to grid
      return $resultRedirect->setPath('*/*/');
   }
}
