<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Banner
 */

namespace Totem\Banner\Controller\Adminhtml;

abstract class Banner extends \Magento\Backend\App\Action
{
   /**
    * Authorization level of a basic admin session
    *
    * @see _isAllowed()
    */
   const ADMIN_RESOURCE = 'Totem_Banner::banner';
   
   /**
    * Core registry
    *
    * @var \Magento\Framework\Registry
    */
   protected $_coreRegistry;
   
   /**
    * @param \Magento\Backend\App\Action\Context $context
    * @param \Magento\Framework\Registry $coreRegistry
    */
   public function __construct(\Magento\Backend\App\Action\Context $context, \Magento\Framework\Registry $coreRegistry)
   {
      $this->_coreRegistry = $coreRegistry;
      
      parent::__construct($context);
   }
   
   /**
    * Init page
    *
    * @param \Magento\Backend\Model\View\Result\Page $resultPage
    * @return \Magento\Backend\Model\View\Result\Page
    */
   protected function initPage($resultPage)
   {
      $resultPage->setActiveMenu('Totem_Banner::totem_banner')
                 ->addBreadcrumb(__('Totem'), __('Totem'))
                 ->addBreadcrumb(__('Banners'), __('Banners'));
      
      return $resultPage;
   }
}
