<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Banner
 */

namespace Totem\Banner\Block\Adminhtml\Banner\Edit;

use Magento\Framework\View\Element\UiComponent\Control\ButtonProviderInterface;

/**
 * Class SaveButton
 * @package Totem\Banner\Block\Adminhtml\Banner\Edit
 */
class SaveButton extends GenericButton implements ButtonProviderInterface
{
   /**
    * @return array
    */
   public function getButtonData()
   {
      return [
         'label' => __('Save Banner'),
         'class' => 'save primary',
         'data_attribute' => [
            'mage-init' => ['button' => ['event' => 'save']],
            'form-role' => 'save',
         ],
         'sort_order' => 90,
      ];
   }
}
