<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Banner
 */

namespace Totem\Banner\Block\Adminhtml\Banner\Edit;

use Magento\Framework\View\Element\UiComponent\Control\ButtonProviderInterface;

/**
 * Class SaveAndContinueButton
 */
class SaveAndContinueButton extends GenericButton implements ButtonProviderInterface
{
   /**
    * @return array
    */
   public function getButtonData()
   {
      return [
         'label' => __('Save and Continue Edit'),
         'class' => 'save',
         'data_attribute' => [
            'mage-init' => [
               'button' => ['event' => 'saveAndContinueEdit'],
            ],
         ],
         'sort_order' => 80,
      ];
   }
}
