<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Banner
 */

namespace Totem\Banner\Block\Adminhtml\Banner\Edit;

use Magento\Framework\View\Element\UiComponent\Control\ButtonProviderInterface;

/**
 * Class DeleteButton
 */
class DeleteButton extends GenericButton implements ButtonProviderInterface
{
   /**
    * @return array
    */
   public function getButtonData()
   {
      $data = [];
      if ($this->getBannerId()):
         $data = [
            'label' => __('Delete Banner'),
            'class' => 'delete',
            'on_click' => 'deleteConfirm(\'' . __(
                  'Are you sure you want to do this?'
               ) . '\', \'' . $this->getDeleteUrl() . '\')',
            'sort_order' => 20,
         ];
      endif;
      
      return $data;
   }
   
   /**
    * @return string
    */
   public function getDeleteUrl()
   {
      return $this->getUrl('*/*/delete', ['banner_id' => $this->getBannerId()]);
   }
}
