<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Banner
 */

namespace Totem\Banner\Api\Data;

use Magento\Framework\Api\SearchResultsInterface;

/**
 * Interface for banner search results.
 * @api
 * @since 100.0.2
 */
interface BannerSearchResultsInterface extends SearchResultsInterface
{
   /**
    * Get banner list.
    *
    * @return \Totem\Banner\Api\Data\BannerInterface[]
    */
   public function getItems();
   
   /**
    * Set banner list.
    *
    * @param \Totem\Banner\Api\Data\BannerInterface[] $items
    * @return $this
    */
   public function setItems(array $items);
}
