<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Banner
 */

namespace Totem\Banner\Api\Data;

/**
 * Banner interface.
 * @api
 * @since 100.0.2
 */
interface BannerInterface
{
   /**#@+
    * Constants for keys of data array. Identical to the name of the getter in snake case
    */
   const BANNER_ID         = 'banner_id';
   const TITLE             = 'title';
   const SUBTITLE          = 'subtitle';
   const LINK_TYPE         = 'link_type';
   const LINK_CATEGORY     = 'link_category';
   const LINK_PAGE         = 'link_page';
   const LINK_CUSTOM       = 'link_custom';
   const LINK_NEW_WINDOW   = 'link_new_window';
   const SHOW_BUTTON       = 'show_button';
   const BUTTON_LABEL      = 'button_label';
   const TYPE              = 'type';
   const IMAGE             = 'image';
   const VIDEO             = 'video';
   const VIDEO_JSON        = 'video_json';
   const CONTENT           = 'content';
   const CREATION_TIME     = 'creation_time';
   const UPDATE_TIME       = 'update_time';
   const IS_ACTIVE         = 'is_active';
   /**#@-*/
   
   /**
    * Get ID
    *
    * @return int|null
    */
   public function getId();
   
   /**
    * Get title
    *
    * @return string|null
    */
   public function getTitle();
   
   /**
    * Get subtitle
    *
    * @return string|null
    */
   public function getSubtitle();
   
   /**
    * Get link type
    *
    * @return string|null
    */
   public function getLinkType();
   
   /**
    * Get link category
    *
    * @return int|null
    */
   public function getLinkCategory();
   
   /**
    * Get link page
    *
    * @return string|null
    */
   public function getLinkPage();
   
   /**
    * Get link custom
    *
    * @return string|null
    */
   public function getLinkCustom();
   
   /**
    * Get link new window
    *
    * @return bool|null
    */
   public function getLinkNewWindow();
   
   /**
    * Get show button
    *
    * @return bool|null
    */
   public function getShowButton();
   
   /**
    * Get button label
    *
    * @return string|null
    */
   public function getButtonLabel();
   
   /**
    * Get type
    *
    * @return string
    */
   public function getType();
   
   /**
    * Get image
    *
    * @return string
    */
   public function getImage();
   
   /**
    * Get video
    *
    * @return string
    */
   public function getVideo();
   
   /**
    * Get video json
    *
    * @return string
    */
   public function getVideoJson();
   
   /**
    * Get content
    *
    * @return string
    */
   public function getContent();
   
   /**
    * Get creation time
    *
    * @return string|null
    */
   public function getCreationTime();
   
   /**
    * Get update time
    *
    * @return string|null
    */
   public function getUpdateTime();
   
   /**
    * Is active
    *
    * @return bool|null
    */
   public function isActive();
   
   /**
    * Set ID
    *
    * @param int $id
    * @return BannerInterface
    */
   public function setId($id);
   
   /**
    * Set title
    *
    * @param string $title
    * @return BannerInterface
    */
   public function setTitle($title);
   
   /**
    * Set subtitle
    *
    * @param string $subtitle
    * @return BannerInterface
    */
   public function setSubtitle($subtitle);
   
   /**
    * Set link type
    *
    * @param string $linkType
    * @return BannerInterface
    */
   public function setLinkType($linkType);
   
   /**
    * Set link category
    *
    * @param int $linkCategory
    * @return BannerInterface
    */
   public function setLinkCategory($linkCategory);
   
   /**
    * Set link page
    *
    * @param string $linkPage
    * @return BannerInterface
    */
   public function setLinkPage($linkPage);
   
   /**
    * Set link custom
    *
    * @param string $linkCustom
    * @return BannerInterface
    */
   public function setLinkCustom($linkCustom);
   
   /**
    * Set link new window
    *
    * @param boolean $linkNewWindow
    * @return BannerInterface
    */
   public function setLinkNewWindow($linkNewWindow);
   
   /**
    * Set show button
    *
    * @param boolean $showButton
    * @return BannerInterface
    */
   public function setShowButton($showButton);
   
   /**
    * Set button label
    *
    * @param string $buttonLabel
    * @return BannerInterface
    */
   public function setButtonLabel($buttonLabel);
   
   /**
    * Set type
    *
    * @param string $type
    * @return BannerInterface
    */
   public function setType($type);
   
   /**
    * Set image
    *
    * @param string $image
    * @return BannerInterface
    */
   public function setImage($image);
   
   /**
    * Set video
    *
    * @param string $video
    * @return BannerInterface
    */
   public function setVideo($video);
   
   /**
    * Set videoJson
    *
    * @param string $videoJson
    * @return BannerInterface
    */
   public function setVideoJson($videoJson);
   
   /**
    * Set content
    *
    * @param string $content
    * @return BannerInterface
    */
   public function setContent($content);
   
   /**
    * Set creation time
    *
    * @param string $creationTime
    * @return BannerInterface
    */
   public function setCreationTime($creationTime);
   
   /**
    * Set update time
    *
    * @param string $updateTime
    * @return BannerInterface
    */
   public function setUpdateTime($updateTime);
   
   /**
    * Set is active
    *
    * @param bool|int $isActive
    * @return BannerInterface
    */
   public function setIsActive($isActive);
}
