<?php
/**
 * @author     Bart de Groot
 * @company    Abovo Media
 * @copyright  Copyright (c) 2017 Abovo Media (http://www.abovomedia.nl)
 * @package    Totem_Banner
 */

namespace Totem\Banner\Api;

/**
 * Banner CRUD interface.
 * @api
 * @since 100.0.2
 */
interface BannerRepositoryInterface
{
   /**
    * Save banner.
    *
    * @param \Totem\Banner\Api\Data\BannerInterface $banner
    * @return \Totem\Banner\Api\Data\BannerInterface
    * @throws \Magento\Framework\Exception\LocalizedException
    */
   public function save(Data\BannerInterface $banner);
   
   /**
    * Retrieve banner.
    *
    * @param int $bannerId
    * @return \Totem\Banner\Api\Data\BannerInterface
    * @throws \Magento\Framework\Exception\LocalizedException
    */
   public function getById($bannerId);
   
   /**
    * Retrieve banners matching the specified criteria.
    *
    * @param \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
    * @return \Totem\Banner\Api\Data\BannerSearchResultsInterface
    * @throws \Magento\Framework\Exception\LocalizedException
    */
   public function getList(\Magento\Framework\Api\SearchCriteriaInterface $searchCriteria);
   
   /**
    * Delete banner.
    *
    * @param \Totem\Banner\Api\Data\BannerInterface $banner
    * @return bool true on success
    * @throws \Magento\Framework\Exception\LocalizedException
    */
   public function delete(Data\BannerInterface $banner);
   
   /**
    * Delete banner by ID.
    *
    * @param int $bannerId
    * @return bool true on success
    * @throws \Magento\Framework\Exception\NoSuchEntityException
    * @throws \Magento\Framework\Exception\LocalizedException
    */
   public function deleteById($bannerId);
}
